<?php
ob_start();
$response = ['success' => false, 'message' => 'ERROR DESCONOCIDO'];

try {
    require_once __DIR__ . '/../core/api.php';
    global $pdo;

    $data = json_decode(file_get_contents('php://input'), true);

    if (isset($data['id'])) {
        try {
            // Se asume que la FK CASCADE eliminará las entradas en complaint_updates
            $sql = "DELETE FROM complaints WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([':id' => $data['id']]);

            if ($stmt->rowCount()) {
                $response['success'] = true;
                $response['message'] = 'QUEJA ELIMINADA';
            } else {
                $response['message'] = 'NO ENCONTRADO';
            }

        } catch (PDOException $e) {
            error_log("Error PDO en complaints-delete.php: " . $e->getMessage());
            $response['message'] = 'ERROR DE BASE DE DATOS';
        }
    } else {
        $response['message'] = 'ID REQUERIDO';
    }

} catch (Exception $e) {
    error_log("Error crítico en complaints-delete.php: " . $e->getMessage());
    $response['message'] = 'ERROR CRITICO';
}

if (ob_get_level() > 0) {
    ob_end_clean(); 
}

header('Content-Type: application/json');
echo json_encode($response);
exit;