<?php 
ob_start();
header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'ERROR DESCONOCIDO'];

try {
    require_once __DIR__ . '/../core/api.php';

    ini_set('display_errors', 0);
    error_reporting(E_ALL);

    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['id']) || empty($input['id'])) {
        throw new Exception('ID requerido.');
    }

    $id = filter_var($input['id'], FILTER_VALIDATE_INT);

    $stmt = $pdo->prepare("DELETE FROM lead_sources WHERE id = ?");
    $stmt->execute([$id]);

    if ($stmt->rowCount() > 0) {
        $response = ['success' => true, 'message' => 'FUENTE ELIMINADA'];
    } else {
        $response = ['success' => false, 'message' => 'No se encontró la fuente o ya fue eliminada.'];
    }

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

if (ob_get_length()) ob_clean();
echo json_encode($response);
exit;
?>