<?php
ob_start();
header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'ERROR DESCONOCIDO'];

try {
    session_start(); 
    require_once '../core/api.php';

    $userId = $_SESSION['user_id'] ?? null; 
    $clientId = filter_var($_POST['client_id'] ?? null, FILTER_VALIDATE_INT);
    $routeId = filter_var($_POST['route_id'] ?? null, FILTER_VALIDATE_INT);
    $weekNumber = filter_var($_POST['week_number'] ?? null, FILTER_VALIDATE_INT);

    if ($clientId === false || $routeId === false || $weekNumber === false || !$clientId || !$routeId || !$weekNumber || empty($userId)) {
        throw new Exception('DATOS FALTANTES O ERROR DE SESION');
    }
    
    $stmt_check_ownership = $pdo->prepare("SELECT 1 FROM routes WHERE id = ? AND user_id = ?");
    $stmt_check_ownership->execute([$routeId, $userId]);
    if ($stmt_check_ownership->rowCount() == 0) {
        throw new Exception('DESASIGNACION NO AUTORIZADA: RUTA NO PERTENECE AL USUARIO');
    }

    $stmt = $pdo->prepare("DELETE FROM route_clients WHERE client_id = ? AND route_id = ? AND week_number = ?");
    $stmt->execute([$clientId, $routeId, $weekNumber]);
    
    if ($stmt->rowCount() > 0) {
        $response = ['success' => true, 'message' => 'CLIENTE QUITADO'];
    } else {
        $response = ['success' => true, 'message' => 'SIN CAMBIOS'];
    }

} catch (PDOException $e) {
    error_log("Error PDO en routes-clients-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => 'ERROR DE BASE DE DATOS'];
} catch (Exception $e) {
    $response = ['success' => false, 'message' => strtoupper($e->getMessage())];
}

if (ob_get_level() > 0) {
    ob_end_clean();
}
echo json_encode($response);
exit;
?>