<?php
ob_start();
header('Content-Type: application/json');
require_once '../core/api.php';

$data = json_decode(file_get_contents('php://input'), true);

try {
    if (empty($data['id'])) throw new Exception('ID requerido');
    $id = (int)$data['id'];

    // Soft Delete: Cambiar estado a 'inactive'
    $stmt = $pdo->prepare("UPDATE staff SET status = 'inactive' WHERE id = ?");
    $stmt->execute([$id]);
    
    $pdo->prepare("UPDATE clients SET staff_id = NULL WHERE staff_id = ?")->execute([$id]);
    $pdo->prepare("UPDATE routes SET staff_id = NULL WHERE staff_id = ?")->execute([$id]);
    $pdo->prepare("UPDATE unique_appointments SET staff_id = NULL WHERE staff_id = ? AND appointment_date >= CURDATE()")->execute([$id]);

    echo json_encode(['success' => true, 'message' => 'Empleado dado de baja']);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
exit;
?>