<?php
require_once(__DIR__ . '/core/init.php');

$academy_videos = [];

try {
    include 'media/videos-crm.php';    
} catch (Exception $e) {
    error_log("Error cargando dependencias en academy.php: " . $e->getMessage());
}

$video_data = get_video_by_id('academy');
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Centro De Aprendizaje <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css">  
    <script src="files/header-manager.js"></script>
    
    <style>
        #lessonPanel.is-open {
            transform: translateX(0);
        }
        body.off-canvas-open {
            overflow: hidden;
        }
    </style>

</head>
<body data-page-title="Centro De Aprendizaje <?php echo htmlspecialchars($branding['crm_name']); ?>"
      data-page-subtitle="Tutoriales Para Aprender A Usar Las Funciones De Tu CRM"
      data-page-icon="tv-minimal-play">

    <div id="toast-container" class="toast-container"></div>

<?php include 'files/gtm-body.php'; ?>

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="fixed inset-0 bg-black/60 z-40 hidden transition-opacity duration-300"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>

<div class="show-widget-container hidden flex justify-end p-0" id="videotutorial-container">
    <button class="show-widget-btn inline-flex items-center gap-3 text-base font-bold text-white bg-[var(--color-primary)] rounded-lg shadow-lg shadow-[var(--color-primary)]/20 py-3 px-6 transform hover:-translate-y-1 hover:shadow-xl transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[var(--color-secondary)]"
        data-widget-id="academia-intro-video">
        <i data-lucide="eye" class="w-5 h-5"></i>
        <span>VER VIDEO PRESENTACIÓN</span>
    </button>
</div>

        </header>

        <div id="content-area" class="p-4 md:p-8 space-y-8">

            <section id="academia-intro-video" class="p-6 md:p-10 video-widget rounded-xl shadow-lg overflow-hidden">
                <div class="blob bl1"></div><div class="blob bl2"></div>
                <div class="relative grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
                    <div class="text-white">
                        <div class="chip mb-4">
                            <i data-lucide="award" class="w-4 h-4"></i>
                            <span class="text-xs tracking-wide ">Aprende A Dominar Tu Sistema De Crecimito</span>
                        </div>
                        <h1 class="text-3xl md:text-4xl lg:text-5xl font-black leading-tight flex items-center gap-3">
                            <i data-lucide="graduation-cap" class="w-9 h-9 text-[var(--color-highlight)]"></i>
                            Academia <?php echo htmlspecialchars($branding['crm_name']); ?>
                        </h1>
                        <p class="mt-3 md:mt-4 text-base md:text-lg text-white/90">
                            ¡Felicidades por dar el paso! En este video te daremos un recorrido rápido por la plataforma para que empieces con el pie derecho. Nuestro objetivo es que domines cada función para hacer crecer tu negocio.
                        </p>
                        <ul class="mt-6 space-y-3 text-white/90">
                            <li class="flex items-center gap-3">
                                <i data-lucide="video" class="w-5 h-5 text-[var(--color-highlight)]"></i>
                                <span>Tutoriales Paso A Paso Para Cada Módulo</span>
                            </li>
                            <li class="flex items-center gap-3">
                                <i data-lucide="zap" class="w-5 h-5 text-[var(--color-highlight)]"></i>
                                <span>Consejos Rápidos Para Maximizar Tu Productividad</span>
                            </li>
                        </ul>
                    </div>

                    <div class="w-full">
                        <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                            <div class="relative w-full" style="padding-bottom: 56.25%;">
                                <video class="absolute top-0 left-0 w-full h-full object-cover" id="videoPlayer" controls controlslist="nodownload" preload="none" poster="<?= htmlspecialchars($video_data['poster_url'] ?? '') ?>">
                                    <source src="<?= htmlspecialchars($video_data['video_url'] ?? '') ?>" type="video/mp4">
                                    TU NAVEGADOR NO SOPORTA LA ETIQUETA DE VIDEO
                                </video>
                                <div id="playOverlay" class="absolute inset-0 flex justify-center items-center cursor-pointer group">
                                    <img src="<?= htmlspecialchars($video_data['poster_url'] ?? '') ?>" alt="<?php echo htmlspecialchars($branding['crm_name']); ?>" class="absolute inset-0 w-full h-full object-cover">
                                    <div class="absolute inset-0 w-full h-full bg-black/70 transition-colors group-hover:bg-black/30"></div>
                                    <i data-lucide="play" class="relative w-16 h-16 text-white opacity-90 group-hover:opacity-100 transition-opacity"></i>
                                </div>
                            </div>
                            <div class="p-4 text-white/90 text-sm flex flex-col md:flex-row md:items-center justify-between gap-2">
                                <span class="inline-flex items-center gap-2">
                                    <i data-lucide="play-circle" class="w-4 h-4 text-[var(--color-highlight)]"></i>
                                    <b>VIDEO:</b> <?= htmlspecialchars($video_data['title'] ?? 'Presentación') ?>
                                </span>

    <button class="hide-widget-btn inline-flex items-center gap-2 text-xs font-black text-[var(--color-highlight)] hover:text-[var(--color-highlight)] transition-colors py-2 md:py-1 px-2 rounded-md justify-center md:justify-end w-full md:w-auto bg-white/10 md:bg-transparent min-h-[44px] md:min-h-0"
        data-widget-id="academia-intro-video"
        title="Ocultar Video">
        OCULTAR VIDEO
        <i data-lucide="square-x" class="w-4 h-4"></i>
    </button>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="academia" class="dashboard-section">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="mb-6">
                        <h4 class="text-2xl font-black text-[var(--color-primary)] mb-4 uppercase flex items-center gap-3">
                            <i data-lucide="monitor-play" class="w-7 h-7 text-[var(--color-secondary)]"></i> TUTORIALES DE LA PLATAFORMA <?php echo htmlspecialchars($branding['crm_name']); ?>
                        </h4>
                        <div class="relative mb-6 input-with-icon">
                            <input type="text" id="video-search" placeholder="Buscar Tutoriales Por Título..."
                                class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent text-gray-700">
                            <i data-lucide="search" class="search-icon w-5 h-5 text-gray-400"></i>
                        </div>
                    </div>

                    <div id="videos-container" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 gap-6">
                    </div>

                    <div id="load-more-container" class="text-center mt-8">
                        <button id="load-more-videos-btn" class="w-full bg-[var(--color-primary)] hover:opacity-90 text-white font-black py-2.5 px-4 rounded-lg uppercase sm:w-auto flex items-center justify-center gap-2 mx-auto">
                            <i data-lucide="loader" class="w-5 h-5"></i> Cargar Más Tutoriales
                        </button>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>

<div id="lessonPanel" class="fixed inset-0 z-50 w-full h-full bg-gray-50 transform transition-transform duration-300 translate-x-full overflow-hidden flex flex-col">
    <div class="flex flex-col h-full">
        <div class="flex-shrink-0 bg-[var(--color-primary)] text-white p-6 flex justify-between items-center shadow-lg z-10">
            <div class="flex items-center">
                <div class="bg-white/10 p-2 rounded-lg mr-4">
                    <i data-lucide="book-open" class="w-6 h-6 text-[var(--color-highlight)]"></i>
                </div>
                <div>
                    <h3 id="lessonPanelTitleText" class="text-3xl font-black uppercase tracking-wide text-[var(--color-highlight)]"></h3>
                    <p class="text-xs text-gray-400 uppercase tracking-wider">Modo Estudio <?php echo htmlspecialchars($branding['crm_name']); ?></p>
                </div>
            </div>
            <button onclick="closeLessonPanel()" class="bg-[var(--color-secondary)] text-white hover:text-[var(--color-highlight)] p-2 rounded-md transition-colors duration-200" title="Cerrar Lección">
                <i data-lucide="x" class="w-6 h-6"></i>
            </button>
        </div>

        <div class="p-4 md:p-8 flex-grow overflow-y-auto bg-[var(--color-background)]">
            <div class="max-w-7xl mx-auto h-full flex flex-col justify-center">
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 items-start">
                    <div class="lg:col-span-2 space-y-8">
                        <div class="w-full aspect-video bg-black rounded-2xl overflow-hidden shadow-2xl relative ring-4 ring-white">
                            <video id="lessonVideoPlayer" class="w-full h-full object-contain" controls preload="metadata"></video>
                            <div id="lessonVideoPoster" class="absolute inset-0 bg-cover bg-center flex items-center justify-center cursor-pointer">
                                <div class="absolute inset-0 bg-black/30 backdrop-blur-[2px]"></div>
                                <i data-lucide="play-circle" class="w-32 h-32 text-white relative z-10 hover:scale-110 transition-transform duration-300 drop-shadow-lg"></i>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-6 lg:sticky lg:top-8">
                        <div class="bg-white p-6 rounded-xl shadow-lg border border-gray-200">
                            <h3 class="text-2xl font-black text-[var(--color-primary)] mb-4 flex items-center gap-2 uppercase">
                                <i data-lucide="check-circle-2" class="w-5 h-5 text-[var(--color-secondary)]"></i> PROGRESO DE APRENDIZAJE
                            </h3>
                            <div class="space-y-3">
                                <button onclick="closeLessonPanel()" class="w-full bg-[var(--color-secondary)] hover:opacity-90 text-white font-black py-2.5 px-4 rounded-lg uppercase flex items-center justify-center gap-2">
                                    <i data-lucide="check" class="w-5 h-5"></i> Finalizar Lección
                                </button>
                            </div>
                        </div>

                        <div class="bg-white p-6 rounded-xl shadow-lg border border-gray-200">
                            <h3 class="text-2xl font-black text-[var(--color-primary)] mb-4 flex items-center gap-2 uppercase">
                                <i data-lucide="navigation" class="w-5 h-5 text-[var(--color-secondary)]"></i> NAVEGACIÓN
                            </h3>
                            <div class="grid grid-cols-2 gap-4">
                                <button id="prevLessonBtn" class="w-full bg-[var(--color-primary)] hover:opacity-90 text-white font-black py-2.5 px-4 rounded-lg uppercase flex items-center justify-center gap-2" disabled>
                                    <i data-lucide="arrow-left" class="w-4 h-4 mr-2"></i> Anterior
                                </button>
                                <button id="nextLessonBtn" class="w-full bg-[var(--color-secondary)] hover:opacity-90 text-white font-black py-2.5 px-4 rounded-lg uppercase flex items-center justify-center gap-2">
                                    Siguiente <i data-lucide="arrow-right" class="w-4 h-4 ml-2"></i>
                                </button>
                            </div>
                        </div>

                        <div class="text-center mt-6">
                            <button onclick="closeLessonPanel()" class="w-full sm:w-auto mx-auto flex items-center justify-center gap-2 text-[var(--color-primary)] hover:text-[var(--color-secondary)] font-bold text-sm uppercase tracking-widest transition-all py-3 px-6 rounded-lg group">
                                <i data-lucide="layout-grid" class="w-4 h-4 group-hover:scale-110 transition-transform"></i>
                                VOLVER A MÓDULOS
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    <?php
    $videos_list = isset($academy_videos) && is_array($academy_videos) ? array_values($academy_videos) : [];
    ?>
    const ALL_VIDEOS_DATA = <?php echo json_encode($videos_list, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE); ?>;
</script>

<script>
(function() {
    'use strict';

    let allVideosData = [];
    let filteredVideosData = [];
    let videosLoadedCount = 0;
    const videosPerPage = 6;
    let currentSearchTerm = '';
    let currentVideoIndex = -1;

    const lessonPanel = document.getElementById('lessonPanel');
    const lessonPanelOverlay = document.getElementById('task-panel-overlay');
    const lessonVideoPlayer = document.getElementById('lessonVideoPlayer');
    const lessonVideoPoster = document.getElementById('lessonVideoPoster');
    const lessonPanelTitleText = document.getElementById('lessonPanelTitleText');
    const videosContainer = document.getElementById('videos-container');
    const loadMoreButton = document.getElementById('load-more-videos-btn');
    const searchInput = document.getElementById('video-search');
    const mobileMenuButton = document.getElementById('mobile-menu-button');
    const sidebar = document.getElementById('sidebar');
    const sidebarOverlay = document.getElementById('sidebar-overlay');
    const prevLessonBtn = document.getElementById('prevLessonBtn');
    const nextLessonBtn = document.getElementById('nextLessonBtn');
    
    const mainVideoPlayer = document.getElementById('videoPlayer');
    const mainPlayOverlay = document.getElementById('playOverlay');

    const sanitizeURL = (url) => {
        if (!url || typeof url !== 'string') return '';
        const lowerUrl = url.toLowerCase();
        if (lowerUrl.startsWith('javascript:') || lowerUrl.startsWith('data:text/html')) {
            return '';  
        }
        return url.replace(/'/g, '%27');
    };

    const createVideoCardHTML = (video, index) => {
        const sanitizedVideoUrl = sanitizeURL(video.video_url);
        const fallbackPosterUrl = `https://placehold.co/600x337/07162d/ffc857?text=VIDEO+${video.title || 'Tutorial'}`;
        const sanitizedPosterUrl = sanitizeURL(video.poster_url) || fallbackPosterUrl;

        const parser = new DOMParser();
        const sanitizedTitle = video.title ? parser.parseFromString(video.title, 'text/html').body.textContent : 'Sin Título';
        const sanitizedDescription = video.description ? parser.parseFromString(video.description, 'text/html').body.textContent : 'Sin descripción.';

        return `
            <div class="video-card flex flex-col rounded-xl overflow-hidden shadow-lg hover:shadow-xl transform hover:scale-102 transition-all duration-300 bg-white border border-gray-200" data-video-index="${index}">
                <div class="video-thumbnail-container relative w-full pt-[56.25%]">
                    <img src="${sanitizedPosterUrl}" alt="Miniatura de video: ${sanitizedTitle}" class="absolute top-0 left-0 w-full h-full object-cover poster-image" loading="lazy">
                    <video class="absolute top-0 left-0 w-full h-full object-cover hidden" controls controlslist="nodownload fullscreen" preload="metadata" src="${sanitizedVideoUrl}"></video>
                    <div class="video-play-button absolute inset-0 flex items-center justify-center bg-black bg-opacity-50 hover:bg-opacity-75 transition-opacity duration-300 cursor-pointer">
                        <i data-lucide="play" class="w-16 h-16 text-white transform hover:scale-110 transition-transform duration-200"></i>
                    </div>
                </div>
                <div class="p-4 flex flex-col flex-grow">
                    <h5 class="font-extrabold text-xl text-gray-800 mb-2 uppercase leading-tight flex items-center gap-2">
                        <i data-lucide="video" class="w-6 h-6 text-[var(--color-primary)] flex-shrink-0"></i> <span class="line-clamp-2">${sanitizedTitle}</span>
                    </h5>
                    <p class="text-sm text-gray-700 flex-grow line-clamp-3 mb-8">${sanitizedDescription}</p>
                    <button type="button" class="btn btn-primary w-full bg-[var(--color-secondary)] hover:opacity-90 text-white font-black py-2.5 px-4 rounded-lg uppercase sm:w-auto flex items-center justify-center gap-2">
                        <i data-lucide="monitor" class="w-5 h-5"></i> Ver Lección
                    </button>
                </div>
            </div>
        `;
    };

    const renderVideos = (isLoadMore = false) => {
        if (!videosContainer || !loadMoreButton) return;

        const lowerSearchTerm = currentSearchTerm.toLowerCase().trim();
        filteredVideosData = lowerSearchTerm ? allVideosData.filter(video =>  
            (video.title?.toLowerCase().includes(lowerSearchTerm)) || 
            (video.description?.toLowerCase().includes(lowerSearchTerm))
        ) : allVideosData;

        if (!isLoadMore) {
            videosContainer.innerHTML = '';
            videosLoadedCount = 0;
        }

        const videosToDisplay = filteredVideosData.slice(videosLoadedCount, videosLoadedCount + videosPerPage);

        if (videosToDisplay.length > 0) {
            const startIndex = videosLoadedCount;
            const html = videosToDisplay.map((video, index) => createVideoCardHTML(video, startIndex + index)).join('');
            videosContainer.insertAdjacentHTML('beforeend', html);
            videosLoadedCount += videosToDisplay.length;
        }

        if (videosLoadedCount === 0 && currentSearchTerm) {
            videosContainer.innerHTML = `<p class="col-span-full text-center text-gray-500 p-8">No se encontraron tutoriales que coincidan con "${currentSearchTerm}".</p>`;
        } else if (videosLoadedCount === 0 && !currentSearchTerm) {
             videosContainer.innerHTML = `<p class="col-span-full text-center text-gray-500 p-8">No hay videos disponibles en este momento.</p>`;
        }

        loadMoreButton.classList.toggle('hidden', videosLoadedCount >= filteredVideosData.length);

        if (typeof lucide !== 'undefined') lucide.createIcons();
    };

    const loadAllVideos = () => {
        if (!videosContainer) return;
        try {
            allVideosData = Array.isArray(ALL_VIDEOS_DATA) ? ALL_VIDEOS_DATA : [];
            renderVideos(); 
        } catch (error) {
            console.error('Error al procesar los datos de videos:', error);
            videosContainer.innerHTML = `<p class="col-span-full text-center text-red-500 p-8">No se pudo cargar el contenido. Error en los datos.</p>`;
        }
    };

    const openLessonPanel = (videoIndex) => {
        const video = filteredVideosData[videoIndex];
        if (!video) return;

        const dashboardVideo = document.getElementById('videoPlayer');
        if (dashboardVideo && !dashboardVideo.paused) {
            dashboardVideo.pause();
        }

        currentVideoIndex = videoIndex;
        lessonPanel.classList.add('is-open');
        if(lessonPanelOverlay) lessonPanelOverlay.classList.add('is-open');
        document.body.classList.add('off-canvas-open');

        const sanitizedVideoUrl = sanitizeURL(video.video_url);
        const sanitizedPosterUrl = sanitizeURL(video.poster_url);

        lessonVideoPlayer.src = sanitizedVideoUrl;
        lessonVideoPlayer.poster = sanitizedPosterUrl;
        lessonPanelTitleText.textContent = video.title;
        const lessonVideoPosterDiv = document.getElementById('lessonVideoPoster');
        if (lessonVideoPosterDiv) {
             lessonVideoPosterDiv.style.backgroundImage = `url('${sanitizedPosterUrl}')`;
        }

        lessonVideoPoster.style.display = 'flex';
        lessonVideoPlayer.style.display = 'none';

        updateNavigationButtons();
    };
    
    const closeLessonPanel = () => {
        lessonVideoPlayer.pause();
        lessonVideoPlayer.src = '';
        lessonPanel.classList.remove('is-open');
        if(lessonPanelOverlay) lessonPanelOverlay.classList.remove('is-open');
        document.body.classList.remove('off-canvas-open');
        currentVideoIndex = -1;
    };

    const handleVideoNavigation = (direction) => {
        const newIndex = currentVideoIndex + direction;
        if (newIndex >= 0 && newIndex < filteredVideosData.length) {
            openLessonPanel(newIndex);
        }
    };

    const updateNavigationButtons = () => {
        if (prevLessonBtn) prevLessonBtn.disabled = currentVideoIndex <= 0;
        if (nextLessonBtn) nextLessonBtn.disabled = currentVideoIndex >= filteredVideosData.length - 1;
    };

    const init = () => {
        loadAllVideos();

        if (mobileMenuButton && sidebar && sidebarOverlay) {
            mobileMenuButton.addEventListener('click', () => {
                sidebar.classList.toggle('-translate-x-full');
                sidebarOverlay.classList.toggle('hidden');
            });
            sidebarOverlay.addEventListener('click', () => {
                sidebar.classList.add('-translate-x-full');
                sidebarOverlay.classList.add('hidden');
            });
        }

        const urlParams = new URLSearchParams(window.location.search);
        const notificationType = urlParams.get('notification_type');
        const notificationMessage = urlParams.get('notification_message');
        if (notificationType && notificationMessage && typeof showToast === 'function') {
            showToast(notificationMessage, notificationType);
        }

        if (mainPlayOverlay && mainVideoPlayer) {
            mainPlayOverlay.addEventListener('click', () => {
                mainPlayOverlay.style.display = 'none';
                mainVideoPlayer.play();
            });
        }

        if (videosContainer) {
            videosContainer.addEventListener('click', (event) => {
                const videoCard = event.target.closest('.video-card');
                if (!videoCard) return;

                const videoPlayButton = event.target.closest('.video-play-button');
                const viewLessonButton = event.target.closest('.btn');
                const videoElement = videoCard.querySelector('video');
                const posterImage = videoCard.querySelector('.poster-image');

                if (viewLessonButton) {
                    const videoIndex = parseInt(videoCard.dataset.videoIndex);
                    openLessonPanel(videoIndex);
                } else if (videoPlayButton) {
                    posterImage.classList.add('hidden');
                    videoPlayButton.classList.add('hidden');
                    videoElement.classList.remove('hidden');
                    videoElement.play();
                }
            });
        }

        if (lessonVideoPoster && lessonVideoPlayer) {
            lessonVideoPoster.addEventListener('click', () => {
                lessonVideoPoster.style.display = 'none';
                lessonVideoPlayer.style.display = 'block';
                lessonVideoPlayer.play();
            });
        }

        if (prevLessonBtn) prevLessonBtn.addEventListener('click', () => handleVideoNavigation(-1));
        if (nextLessonBtn) nextLessonBtn.addEventListener('click', () => handleVideoNavigation(1));
        
        if (lessonPanelOverlay) lessonPanelOverlay.addEventListener('click', closeLessonPanel);

        if (searchInput) {
            searchInput.addEventListener('input', () => {
                currentSearchTerm = searchInput.value;
                renderVideos();
            });
        }

        if(loadMoreButton) loadMoreButton.addEventListener('click', () => renderVideos(true));
    };

    window.closeLessonPanel = closeLessonPanel;
    document.addEventListener('DOMContentLoaded', init);
})();
</script>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const toggleWidgetVisibility = (widgetId, isHidden) => {
        const widget = document.getElementById(widgetId);
        const showContainer = document.querySelector('.show-widget-container');
        const videoPlayer = widget ? widget.querySelector('video') : null;

        if (!widget || !showContainer) return;

        if (isHidden) {
            widget.classList.add('hidden');
            showContainer.classList.remove('hidden');
            if (videoPlayer) videoPlayer.pause(); 
        } else {
            widget.classList.remove('hidden');
            showContainer.classList.add('hidden');
        }
        localStorage.setItem(`hide_${widgetId}`, isHidden ? 'true' : 'false');
    };

    document.querySelectorAll('.hide-widget-btn').forEach(button => {
        button.addEventListener('click', (event) => {
            const widgetId = event.currentTarget.dataset.widgetId;
            toggleWidgetVisibility(widgetId, true); 
        });
    });

    document.querySelectorAll('.show-widget-btn').forEach(button => {
        button.addEventListener('click', (event) => {
            const widgetId = event.currentTarget.dataset.widgetId;
            toggleWidgetVisibility(widgetId, false); 
        });
    });

    document.querySelectorAll('.video-widget').forEach(widget => {
        const widgetId = widget.id;
        const isHidden = localStorage.getItem(`hide_${widgetId}`) === 'true';
        if (isHidden) {
            toggleWidgetVisibility(widgetId, true);
        }
    });
});
</script>
<script src="files/toast.js"></script>
</body>
</html>