<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso Denegado <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css">
    
</head>
<body class="flex">

    <?php include 'menu.php'; ?>

    <div class="flex-1 flex flex-col">
        <main class="flex-1 flex flex-col content-background">
            <div class="overlay p-4 flex-1">
                
                <div class="max-w-2xl w-full text-center content-card">
                    <div class="flex justify-center mb-6">
                        <i data-lucide="lock" class="h-28 w-28 text-red-500 drop-shadow-lg"></i>
                    </div>
                    <h1 class="text-6xl font-extrabold text-white leading-tight drop-shadow-md">
                        Acceso Denegado
                    </h1>
                    <p class="mt-4 text-xl text-gray-200 max-w-lg mx-auto drop-shadow-md">
                        Esta Funcionalidad NO Está Incluida En Tu Plan Actual.<br />Contacta A Soporte Si Crees Que Esto Es Un Error.
                    </p>
                    
                    <div class="mt-10 grid grid-cols-1 sm:grid-cols-2 gap-4 max-w-lg mx-auto">
                        <a href="mailto:soporte@tunegociocrm.com" class="btn-support w-full flex items-center justify-center p-4 rounded-lg uppercase font-bold text-lg shadow-lg">
                            <i data-lucide="shield-question" class="w-6 h-6 mr-3"></i>
                            <span>Soporte Técnico</span>
                        </a>
                        <a href="https://orozdesign.com" target="_blank" class="btn-info w-full flex items-center justify-center p-4 rounded-lg uppercase font-bold text-lg shadow-lg">
                            <i data-lucide="gem" class="w-6 h-6 mr-3"></i>
                            <span>Ver Planes</span>
                        </a>
                    </div>
                </div>

            </div>
        </main>
    </div>

    <script>
        lucide.createIcons();
    </script>
</body>
</html>