<?php
// /api-db/ia-facebook-page-optimizer-delete.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

try {
    $business_id = 1; // Asumiendo business_info_id = 1
    
    // Eliminar la fila completa de la tabla
    $sql = "DELETE FROM ia_facebook_page_optimizer_results WHERE business_info_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Plan de acción eliminado exitosamente.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'No se encontró ningún plan de acción para eliminar.']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al eliminar el plan: ' . $e->getMessage()]);
}
?>