<?php
// /IAMarketing/api-db/ia-local-market-analsyis-create.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['analisis_mercado']) || !isset($data['analisis_competencia']) || !isset($data['plan_estrategico'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Faltan datos del análisis de mercado.']);
    exit;
}

$business_id = 1; // Asumiendo business_info_id = 1
$analisis_mercado = $data['analisis_mercado'];
$analisis_competencia = $data['analisis_competencia'];
$plan_json = json_encode($data['plan_estrategico']); // Codificar array a JSON

try {
    // 1. Verificar si ya existe un registro
    $check_sql = "SELECT id FROM ia_local_market_analsyis_results WHERE business_info_id = ?";
    $check_stmt = $pdo->prepare($check_sql);
    $check_stmt->execute([$business_id]);
    
    if ($check_stmt->fetch(PDO::FETCH_ASSOC)) {
        http_response_code(409); // Conflict
        echo json_encode(['success' => false, 'message' => 'Ya existe un Análisis de Mercado. Use la función de actualizar.']);
        exit;
    }
    
    // 2. Insertar el nuevo registro
    $sql = "INSERT INTO ia_local_market_analsyis_results (business_info_id, analisis_mercado, analisis_competencia, plan_estrategico) VALUES (?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id, $analisis_mercado, $analisis_competencia, $plan_json]);
    
    echo json_encode(['success' => true, 'message' => 'Análisis de Mercado creado exitosamente.']);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al crear el Análisis: ' . $e->getMessage()]);
}
?>