<?php
// /IAMarketing/api-db/ia-local-market-analsyis-update.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['analisis_mercado']) || !isset($data['analisis_competencia']) || !isset($data['plan_estrategico'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Faltan datos del análisis de mercado.']);
    exit;
}

$business_id = 1; // Asumiendo business_info_id = 1
$analisis_mercado = $data['analisis_mercado'];
$analisis_competencia = $data['analisis_competencia'];
$plan_json = json_encode($data['plan_estrategico']);

try {
    // Actualizar el registro existente
    $sql = "UPDATE ia_local_market_analsyis_results SET analisis_mercado = ?, analisis_competencia = ?, plan_estrategico = ? WHERE business_info_id = ?";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$analisis_mercado, $analisis_competencia, $plan_json, $business_id]);
    
    echo json_encode(['success' => true, 'message' => 'Análisis de Mercado actualizado exitosamente.']);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al actualizar el Análisis: ' . $e->getMessage()]);
}
?>