<?php
// /IAMarketing/api-db/project-proposals-delete.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexin a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$business_id = 1; // Para seguridad, nos aseguramos que solo borre las suyas

if (isset($data['id'])) {
    
    $id = $data['id'];

    try {
        // Eliminar el registro por ID, asegurndose que pertenezca al business_id
        $sql = "DELETE FROM ia_project_proposals_results WHERE id = ? AND business_info_id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$id, $business_id]);
        
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'Propuesta eliminada exitosamente.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'No se pudo eliminar la propuesta (probablemente ya no existe).']);
        }
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Error de base de datos al eliminar la propuesta: ' . $e->getMessage()]);
    }
} else {
     http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'No se recibi el ID de la propuesta.']);
}
?>