<?php
// /IAMarketing/api-db/ia-swot-analysis-delete.php
ob_start();
// Incluye el archivo de conexión a la base de datos (que define $pdo)
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

try {
    $business_id = 1; // Asumiendo business_info_id = 1 (hardcoded por ahora)
    
    // Eliminar la fila completa de la tabla dedicada
    $sql = "DELETE FROM ia_swot_analysis_results WHERE business_info_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id]);
    
    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Análisis FODA eliminado exitosamente.']);
    } else {
        // No se encontró un FODA para eliminar, lo cual no es un error
        echo json_encode(['success' => true, 'message' => 'No se encontró ningún Análisis FODA para eliminar.']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al eliminar el FODA: ' . $e->getMessage()]);
}
?>