<?php
// roles.php
return [
    'owner' => ['name' => 'Dueño de Negocio'], 

    // =======================================================
    // 1. MANAGER (Operativo)
    // =======================================================
    'manager' => [
        'name'        => 'Manager / Operaciones',
        'permissions' => [
            // Fase 1: Clientes y Operación Diaria
            'dashboard_view' => true,
            'assistant_view' => true,
            'agenda_view'    => true, 'agenda_create' => true, 'agenda_edit' => true, 'agenda_delete' => true,
            'clients_view'   => true, 'clients_create' => true, 'clients_edit' => true, 
            'projects_view'  => true, 'projects_create' => true, 'projects_edit' => true,
            'recurring_view' => true, 'recurring_manage' => true,
            'routes_view'    => true, 'routes_manage' => true,

            // Fase 2: Operación Interna
            'services_view'    => true, 
            'staff_view'       => true, 'staff_create' => true, 'staff_edit' => true, 
            'complaints_view'  => true, 'complaints_resolve' => true,
            
            'finances_view' => false, 

            // Fase 3: Ventas (Supervisión)
            'leads_view'       => true, 'leads_assign' => true,
            'quotes_view'      => true,
            
            // Herramientas
            'academy_view'     => true 
        ]
    ],

    // =======================================================
    // 2. FINANCIERO (Contador)
    // =======================================================
    'finance' => [
        'name'        => 'Contador / Financiero',
        'permissions' => [
            'dashboard_view'   => true, 

            'invoices_view'    => true, 
            'finances_view'    => true, 
            'finances_export'  => true, 
            'performance_view' => true, 
            
            // Referencias (Necesita ver qué se cobra)
            'clients_view'     => true,
            'quotes_view'      => true, 
            'projects_view'    => true,
            'recurring_view'   => true,

            // BLOQUEADOS EXPRESAMENTE
            // 'finances_create' => false,
            // 'finances_delete' => false,
            // 'invoices_create' => false
        ]
    ],

    // =======================================================
    // 3. MARKETER (Ventas)
    // =======================================================
    'marketer' => [
        'name'        => 'Marketing / Ventas',
        'permissions' => [
            'dashboard_view' => true,

            // Fase 3: Su Área Principal
            'leads_view'           => true, 
            'leads_create'         => true, 
            'leads_edit'           => true, 
            'leads_delete'         => false, 
            
            'lead_funnel_view'     => true, 'lead_funnel_manage' => true,
            'discarded_leads_view' => true, 
            
            'quotes_view'          => true, 
            'quotes_create'        => true, 
            'quotes_edit'          => true,
            'quotes_delete'        => false,
            
            'quotes_funnel_view'   => true,

            // Referencias
            'services_view'        => true, 
            'academy_view'         => true,

            // BLOQUEADOS TOTALMENTE
            // 'finances_view' => false,
            // 'invoices_view' => false,
            // 'staff_view'    => false
        ]
    ]
];
?>