<?php
// --- Desactivar errores en producción ---
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);
// --- --- ---

// Pon tu llave secreta
$API_KEY = 'MWxjQ-HHzZ1pfWPr.ykIEk_7Dcl6UvnJ5ia0JbsscFUibIYWXvqQRFbvJzW3MzBxK';

// Tu dominio (a dónde vuelve el cliente)
$returnUrl = 'https://crm.tunegociolocal.com/account';

// La URL base correcta de la API de Dodo
$BASE_URL = 'https://live.dodopayments.com';

// -------------------------------------------------
$email = isset($_GET['email']) ? $_GET['email'] : null;
if (!$email) {
    http_response_code(400);
    echo 'Error: Falta el email del cliente.';
    exit;
}

// 1. CONEXIÓN A LA BASE DE DATOS USANDO TU LÓGICA
try {
    // Incluye el archivo que crea la conexión $pdo
    require_once __DIR__ . '/db/db_connection.php'; 
    
    // --- SOLUCIÓN VITAL ---: Renombra $pdo a $db para que el script funcione
    $db = $pdo; 
    
    if (!isset($db)) {
        throw new Exception("Error de Conexión: La variable \$db no fue creada.");
    }

    // 2. BUSCAR EL CUSTOMER ID EN LA BASE DE DATOS
    // Si tu columna NO es 'dodo_customer_id', AJUSTA AQUÍ.
    $stmt = $db->prepare("SELECT dodo_customer_id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    $customerId = $user['dodo_customer_id'] ?? null;
    
    if (!$customerId) {
        // Esto ocurrirá si el cliente no ha pagado (y por lo tanto, no tiene Dodo ID)
        throw new Exception("Error de Datos: Cliente no encontrado o no tiene ID de Dodo (pago pendiente).");
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo 'Error del Portal: ' . htmlspecialchars($e->getMessage());
    exit;
}

// 3. ENVIAR LA SOLICITUD A DODO (ENDPOINT CORRECTO)
// Endpoint: /customers/{customer_id}/customer-portal/session
$apiUrl = "{$BASE_URL}/customers/{$customerId}/customer-portal/session";

$ch = curl_init();
$params = http_build_query(['return_url' => $returnUrl, 'send_email' => 'false']);
curl_setopt($ch, CURLOPT_URL, $apiUrl . '?' . $params); 
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, null); 
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer {$API_KEY}",
    "Content-Type: application/json"
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 20);

$res = curl_exec($ch);
$curl_error_message = curl_error($ch);
curl_close($ch);

$data = $res ? json_decode($res, true) : null;

if (!empty($data['link'])) {
    // El campo de éxito es 'link'
    header('Location: ' . $data['link']);
    exit;
}

// Si Dodo falla (ej. si el ID es inválido aunque exista en la DB)
http_response_code(500);
echo 'Error: El servidor de Dodo rechazó la solicitud. Revisa el log o contacta a soporte.';
error_log("Dodo Portal API Error (Final): " . $res);

?>