<?php
ob_start();
$response = ['success' => false, 'message' => 'DATOS INVALIDOS'];

try {
    require_once __DIR__ . '/../core/api.php';
    global $pdo;

    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['complaint_id'], $_POST['message'], $_POST['type'])) {
        try {
            $sql = "INSERT INTO complaint_updates (complaint_id, message, type) VALUES (:complaint_id, :message, :type)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':complaint_id' => $_POST['complaint_id'],
                ':message' => trim($_POST['message']),
                ':type' => $_POST['type']
            ]);
            
            $response['success'] = true;
            $response['message'] = 'ACTUALIZACION GUARDADA';

        } catch (PDOException $e) {
            error_log("Error PDO en complaints-add-update.php: " . $e->getMessage());
            $response['message'] = 'ERROR DE BASE DE DATOS';
        }
    }

} catch (Exception $e) {
    error_log("Error crítico en complaints-add-update.php: " . $e->getMessage());
    $response['message'] = 'ERROR CRITICO';
}

if (ob_get_level() > 0) {
    ob_end_clean(); 
}

header('Content-Type: application/json');
echo json_encode($response);
exit;