<?php
// db-business_config.php
require_once(__DIR__ . '/db_connection.php'); 

function cleanPhoneNumber($phone) {
    return preg_replace('/[^0-9]/', '', $phone ?? '');
}

$business_data = [];
$conn_config = @new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if (!$conn_config->connect_error) {
    $stmt = $conn_config->prepare("SELECT 
        company_name AS business_name, full_name AS owner_name, license_number,
        site_email AS email_primary, phone_primary, phone_secondary, whatsapp,
        logo_url AS logo_filename, website_url, timezone
    FROM business_info LIMIT 1");
    
    if ($stmt) {
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows === 1) {
            $business_data = $result->fetch_assoc();
        }
        $stmt->close();
    }
    $conn_config->close();
}

// --- DEFINICIÓN DE CONSTANTES ---

// --- LÓGICA MEJORADA PARA LA URL DEL LOGO ---
// 1. Obtener la URL base del sitio y la ruta del logo
$base_url = rtrim($business_data['website_url'] ?? '', '/'); // URL del sitio, ej: https://flowclean.com
$logo_path = $business_data['logo_filename'] ?? 'img/BusinessLogo.webp'; // Ruta relativa, ej: uploads/logo.webp

// 2. Construir la URL completa e infalible
$full_logo_url = $base_url . '/' . ltrim($logo_path, '/');

// --- BRANDING Y SITIO WEB (AHORA USA LA URL COMPLETA) ---
define('LOGO_FILENAME', $full_logo_url); 
define('WEBSITE_URL', $base_url);

// --- OTRAS CONSTANTES ---
define('BUSINESS_NAME', $business_data['business_name'] ?? 'FlowClean Services');
define('BUSINESS_OWNER', $business_data['owner_name'] ?? ''); 
define('BUSINESS_LICENSE_NUMBER', $business_data['license_number'] ?? ''); 
define('BUSINESS_TIMEZONE', $business_data['timezone'] ?? 'America/Los_Angeles'); 
define('EMAIL_PRIMARY', $business_data['email_primary'] ?? '');
define('PHONE_PRIMARY', $business_data['phone_primary'] ?? ''); 
define('PHONE_SECONDARY', $business_data['phone_secondary'] ?? '');
define('WHATSAPP_NUMBER', $business_data['whatsapp'] ?? '');
define('PHONE_PRIMARY_CLICK', '1' . cleanPhoneNumber($business_data['phone_primary'] ?? ''));
define('PHONE_SECONDARY_CLICK', '1' . cleanPhoneNumber($business_data['phone_secondary'] ?? ''));
define('WHATSAPP_NUMBER_CLICK', '1' . cleanPhoneNumber($business_data['whatsapp'] ?? ''));
define('RENEWAL_DATE', '2025-12-31');
define('OROZDESIGN_REVIEW_LINK', 'https://g.page/r/CWd9sGMLzvLCEAE/review'); 
?>