<?php 
ob_start();
header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'ERROR DESCONOCIDO'];

try {
    require_once '../core/api.php';

    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    error_reporting(E_ALL);

    $data = json_decode(file_get_contents('php://input'), true);

    if (!isset($data['id'])) { 
        throw new Exception('ID REQUERIDO');
    }

    $id = filter_var($data['id'], FILTER_VALIDATE_INT);
    if ($id === false) {
        throw new Exception('ID INVALIDO');
    }

    // 1. OBTENER EL NOMBRE DE LA CATEGORÍA ANTES DE BORRAR
    $stmtName = $pdo->prepare("SELECT name FROM service_categories WHERE id = ? LIMIT 1");
    $stmtName->execute([$id]);
    $categoryName = $stmtName->fetchColumn();

    if (!$categoryName) {
        throw new Exception('CATEGORIA NO ENCONTRADA');
    }

    // 2. VERIFICAR SI HAY SERVICIOS USANDO ESTA CATEGORÍA
    $stmtCheck = $pdo->prepare("SELECT COUNT(*) FROM services WHERE category = ?");
    $stmtCheck->execute([$categoryName]);
    $linkedServices = $stmtCheck->fetchColumn();

    if ($linkedServices > 0) {
        throw new Exception("NO SE PUEDE ELIMINAR: HAY $linkedServices SERVICIOS EN ESTA CATEGORÍA. PRIMERO REASÍGNALOS O BORRALOS.");
    }

    // 3. PROCEDER CON EL BORRADO SI ESTÁ LIMPIO
    $sql = "DELETE FROM service_categories WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute([$id])) {
        $response = ['success' => true, 'message' => 'CATEGORIA ELIMINADA'];
    } else {
        throw new Exception('FALLO AL EJECUTAR ELIMINACION');
    }

} catch (PDOException $e) {
    error_log("PDO Error: " . $e->getMessage());
    $response['message'] = 'ERROR DE BASE DE DATOS';
} catch (Exception $e) {
    $response['message'] = strtoupper($e->getMessage());
}

if (ob_get_level() > 0) ob_end_clean();
echo json_encode($response);
exit;
?>