<?php 
ob_start();
header('Content-Type: application/json');
$response_data = ['success' => false, 'services' => [], 'message' => 'ERROR DESCONOCIDO'];

try {
    require_once '../core/api.php';

    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    error_reporting(E_ALL);

    $stmt = $pdo->query("SELECT id, name, price, category, description, image_path, features, youtube_link, gallery_images FROM services ORDER BY name ASC");
    $services = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $formatted_services = [];
    foreach ($services as $service) {
        $formatted_services[] = [
            'id' => (int)$service['id'],
            'name' => filter_var($service['name'], FILTER_SANITIZE_FULL_SPECIAL_CHARS),
            'price' => (float)$service['price'],
            'category' => filter_var($service['category'], FILTER_SANITIZE_FULL_SPECIAL_CHARS),
            'description' => $service['description'], 
            'image_path' => $service['image_path'],
            'features' => $service['features'],    
            'youtube_link' => $service['youtube_link'], 
            'gallery_images' => $service['gallery_images'],
        ];
    }

    $response_data = ['success' => true, 'services' => $formatted_services];
} catch (PDOException $e) {
    error_log("PDO Error: " . $e->getMessage());
    $response_data['message'] = 'ERROR DE BASE DE DATOS';
} catch (Exception $e) {
    $response_data['message'] = 'ERROR INESPERADO';
}

if (ob_get_level() > 0) ob_end_clean();
echo json_encode($response_data);
exit;
?>