/**
 * SISTEMA DE NOTIFICACIONES TOAST - SISTEMA FLOWCRM
 * Versión Universal Modularizada
 */
window.showToast = function(message, type = 'success') {
    // 1. Buscar el contenedor
    let container = document.getElementById('toast-container');
    
    // Si no existe, lo creamos dinámicamente (Seguridad)
    if (!container) {
        container = document.createElement('div');
        container.id = 'toast-container';
        container.className = 'toast-container';
        document.body.appendChild(container);
    }

    // 2. Crear el elemento toast
    const toast = document.createElement('div');

    // Configuración visual según el tipo
    let typeClass = 'toast-success';
    let iconName = 'check-circle-2'; 

    if (type === 'error' || type === 'danger') {
        typeClass = 'toast-error';
        iconName = 'alert-octagon';
    } else if (type === 'warning') {
        typeClass = 'toast-warning';
        iconName = 'alert-triangle';
    } else if (type === 'info') {
        typeClass = 'toast-info';
        iconName = 'info';
    }

    // Aplicar clases
    toast.className = `toast ${typeClass} flex items-center justify-start shadow-2xl border-l-4`;
    
    // Inyectar contenido HTML
    toast.innerHTML = `
        <div class="flex-shrink-0">
            <i data-lucide="${iconName}" class="w-8 h-8 text-[var(--color-highlight)] drop-shadow-md"></i>
        </div>
        <div class="ml-3">
            <p class="text-md font-black text-white uppercase tracking-wider drop-shadow-sm">
                ${message}
            </p>
        </div>
    `;

    // Agregar al contenedor
    container.appendChild(toast);

    // Renderizar iconos si Lucide está cargado
    if (typeof lucide !== 'undefined') {
        lucide.createIcons({ root: toast });
    }

    // Animación de entrada
    requestAnimationFrame(() => {
        toast.classList.add('show');
    });

    // Eliminar automáticamente después de 4 segundos
    setTimeout(() => {
        toast.classList.remove('show');
        setTimeout(() => {
            if (toast.parentElement) {
                toast.remove();
            }
        }, 300);
    }, 4000);
};