<?php
// get_active_token.php
// Script de utilidad para generar un nuevo token de prueba
require_once 'db/db_connection.php'; // Asegúrate de que esta ruta sea correcta
$base_url = "http://localhost/crm/verify-service.php"; // ***AJUSTA ESTA URL SI ES NECESARIO***

$client_id_test = 73; // Javier Ortiz
$staff_id_test = 2;  // Liam Rodriguez

// --------------------------------------------------------------------------------
// Línea 10 del nuevo script:
try { // <-- Inicio del bloque TRY (línea 10)
    // 1. Crear una nueva cita con un token fresco
    $stmt_insert = $pdo->prepare("INSERT INTO unique_appointments 
        (user_id, client_id, service_id, appointment_date, appointment_time, status, public_token, created_at, recurring_parent_id, staff_id, client_rating, client_feedback, verified_at, verification_token)
        VALUES
        (1, ?, 42, CURDATE(), '12:00:00', 'confirmed', 'TEST_TOKEN', NOW(), NULL, ?, 5, NULL, NULL, SHA2(UUID(), 256))");

    $stmt_insert->execute([$client_id_test, $staff_id_test]);
    $new_appointment_id = $pdo->lastInsertId();

    // 2. Obtener el token recién generado
    $stmt_select = $pdo->prepare("SELECT verification_token, appointment_date FROM unique_appointments WHERE id = ?");
    $stmt_select->execute([$new_appointment_id]);
    $result = $stmt_select->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        $new_token = $result['verification_token'];
        $test_url = $base_url . "?token=" . $new_token;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Token de Prueba Generado</title>
    <style>body{font-family: sans-serif; padding: 20px;} pre{background: #eee; padding: 15px; border: 1px solid #ccc; white-space: pre-wrap; word-wrap: break-word;} .success{color: green;} .error{color: red;}</style>
</head>
<body>
    <h1>🎉 Nuevo Token de Verificación Activo</h1>
    <p class="success">Se creó la cita ID **<?php echo $new_appointment_id; ?>** para el cliente 73 (Javier Ortiz) con Liam Rodriguez (ID 2).</p>
    <p>Utiliza la siguiente URL para la prueba. Una vez que la uses, dejará de funcionar.</p>

    <h2>URL de Prueba Activa:</h2>
    <pre><?php echo htmlspecialchars($test_url); ?></pre>

    <h2>Instrucciones:</h2>
    <ol>
        <li>Copia y pega la URL de arriba en tu navegador.</li>
        <li>Completa la calificación y el comentario.</li>
        <li>Haz clic en "Confirm Service".</li>
        <li>Vuelve a probar la misma URL. Debería mostrar el **VERIFICATION ERROR** (si lo hace, ¡tu sistema funciona!).</li>
    </ol>
</body>
</html>

<?php
    } else {
        echo "<p class='error'>Error al recuperar el token generado.</p>";
    }

} catch (PDOException $e) { // <-- Bloque CATCH requerido para manejar excepciones
    // Manejo de errores de la base de datos
    error_log("DB Error in get_active_token: " . $e->getMessage());
    echo "<p class='error'>Ocurrió un error de conexión o base de datos. Detalles: " . htmlspecialchars($e->getMessage()) . "</p>";
}
// --------------------------------------------------------------------------------
?>