<?php
// /db/client_cancel_appointment.php
session_start();
require_once('db-business_config.php'); // Asegúrate que la ruta es correcta

// Verifica que el cliente esté logueado
if (!isset($_SESSION['client_id'])) {
    echo json_encode(['success' => false, 'message' => 'Error: No autorizado.']);
    exit();
}

// Obtiene los datos del POST
$cita_id_full = $_POST['cita_id'] ?? null; // e.g., 'cita-unica-123'
$client_id = $_SESSION['client_id'];

// Separa el ID
$parts = explode('-', $cita_id_full);
$appointment_id = end($parts); // Obtiene '123'

if (!$appointment_id) {
    echo json_encode(['success' => false, 'message' => 'Error: ID de cita inválido.']);
    exit();
}

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Error de conexión.']);
    exit();
}

// Prepara la consulta para actualizar el estado de la cita
// Asegúrate que la cita pertenezca al cliente por seguridad
$stmt = $conn->prepare(
    "UPDATE unique_appointments SET status = 'cancelled' WHERE id = ? AND client_id = ?"
);
$stmt->bind_param('ii', $appointment_id, $client_id);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        // Éxito
        echo json_encode(['success' => true, 'message' => 'Cita cancelada exitosamente.']);
    } else {
        // No se afectaron filas (quizás la cita no era de ese cliente o no existía)
        echo json_encode(['success' => false, 'message' => 'Error: No se pudo encontrar la cita.']);
    }
} else {
    // Error de base de datos
    echo json_encode(['success' => false, 'message' => 'Error al actualizar la base de datos.']);
}

$stmt->close();
$conn->close();
?>