<?php
session_start();
require_once('db_connection.php'); // Conexión a la base de datos PDO

// 1. VERIFICAR QUE EL CLIENTE ESTÉ LOGUEADO Y QUE EL MÉTODO SEA POST
if (!isset($_SESSION['client_id']) || $_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: ../clients/login.php');
    exit();
}

// 2. OBTENER DATOS Y VALIDAR
$client_id = $_SESSION['client_id'];
$complaint_id = filter_input(INPUT_POST, 'complaint_id', FILTER_VALIDATE_INT);

if (!$complaint_id) {
    // Si no hay un ID de queja válido, simplemente redirigir
    header('Location: ../clients/dashboard.php#complaints');
    exit();
}

// 3. EJECUTAR LA ACTUALIZACIÓN EN LA BASE DE DATOS
try {
    // Preparamos la consulta para actualizar el estado a 'Resuelto'
    // IMPORTANTE: Añadimos "AND client_id = ?" como medida de seguridad
    // para asegurar que un cliente solo pueda modificar SUS PROPIOS reportes.
    $stmt = $pdo->prepare(
        "UPDATE complaints 
         SET status = 'Resuelto' 
         WHERE id = ? AND client_id = ? AND status = 'Acción Requerida'"
    );
    
    $stmt->execute([$complaint_id, $client_id]);

    // Verificar si la fila fue realmente actualizada
    if ($stmt->rowCount() > 0) {
        $_SESSION['feedback'] = ['type' => 'success', 'message' => 'Report marked as resolved successfully!'];
    } else {
        // Esto puede pasar si el reporte no existía, no pertenecía al cliente, o no estaba en 'Acción Requerida'
        $_SESSION['feedback'] = ['type' => 'error', 'message' => 'Could not update the report. It may have been updated already.'];
    }

} catch (PDOException $e) {
    error_log("Error resolving complaint: " . $e->getMessage());
    $_SESSION['feedback'] = ['type' => 'error', 'message' => 'A database error occurred.'];
}

// Redirigir siempre de vuelta a la sección de quejas del dashboard
header('Location: ../clients/dashboard.php#complaints');
exit();
?>