<?php
// logout.php
session_start();

// 1. Destruir todas las variables de sesión.
$_SESSION = array();

// 2. Si se utiliza una cookie de sesión (la configuración predeterminada), 
// también debe destruirse. Nota: Esto no es estrictamente necesario si solo
// usas $_SESSION, pero es una buena práctica de seguridad.
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// 3. Finalmente, destruir la sesión.
session_destroy();

// 4. Redirigir al usuario al login (o a la página principal).
// Usaremos el index.php, que a su vez redirigirá al login.
header('Location: index.php');
exit();
?>