<?php
declare(strict_types=1);

// 1. SEGURIDAD Y CARGA DEL N03CLEO
if (!isset($pdo)) {
    $rutaInit = __DIR__ . '/core/init.php';
    if (file_exists($rutaInit)) {
        require_once $rutaInit;
    }
}

global $pdo, $client_info;

$businessName     = __('profile_default_business'); 
$userFullName     = __('profile_default_user');
$userProfilePhoto = "brand/img/Placeholder.webp";

try {
    if (isset($pdo) && $pdo instanceof PDO) {
        
        // A. OBTENER DATOS DEL NEGOCIO
        if (!empty($client_info['business_name'])) {
            $businessName = $client_info['business_name'];
        } else {
            // Prioridad 2: Consulta directa de respaldo (Fallback)
            $stmtBiz = $pdo->prepare("SELECT company_name FROM business_info ORDER BY id DESC LIMIT 1");
            $stmtBiz->execute();
            $bizData = $stmtBiz->fetch(PDO::FETCH_ASSOC);
            
            if ($bizData) {
                $businessName = $bizData['company_name'];
            }
        }

        // B. OBTENER DATOS DEL USUARIO ACTUAL
        $currentUserId = $_SESSION['user_id'] ?? null;

        if ($currentUserId) {
            $stmtUser = $pdo->prepare("SELECT full_name, profile_photo_url FROM users WHERE user_id = ? LIMIT 1");
            $stmtUser->execute([$currentUserId]);
            $userData = $stmtUser->fetch(PDO::FETCH_ASSOC);

            if ($userData) {
                $userFullName = $userData['full_name'] ?? $userFullName;
                
                if (!empty($userData['profile_photo_url'])) {
                    $userProfilePhoto = $userData['profile_photo_url'];
                }
            }
        }
    }
} catch (Exception $e) {
    // Error silencioso en interfaz, registro en log
    error_log("Profile Component Error: " . $e->getMessage());
}

// 3. SANITIZACI07N DE SALIDA (XSS PROTECTION)
$safeBusinessName = htmlspecialchars($businessName, ENT_QUOTES, 'UTF-8');
$safeUserName     = htmlspecialchars($userFullName, ENT_QUOTES, 'UTF-8');
$safeUserPhoto    = htmlspecialchars($userProfilePhoto, ENT_QUOTES, 'UTF-8');
?>

<div class="pt-6 pb-4 text-center px-4">
    <div class="relative inline-block">
        <img class="w-16 h-16 md:w-24 md:h-24 rounded-full mx-auto ring-4 ring-[var(--color-highlight)] ring-offset-2 ring-offset-[var(--color-primary)] object-cover" 
             src="<?php echo $safeUserPhoto; ?>" 
             alt="<?php echo $safeUserName; ?>">
        <span class="absolute bottom-1 right-1 block h-3.5 w-3.5 md:h-4 md:w-4 rounded-full bg-green-400 ring-2 ring-[var(--color-primary)]"></span>
    </div>
    <h3 class="font-extrabold text-base md:text-lg mt-3 leading-tight text-white">
        <?php echo $safeUserName; ?>
    </h3>
    <p class="text-xs md:text-sm text-white/70">
        <?php echo $safeBusinessName; ?>
    </p>
</div>

<div class="px-6 py-2">
    <div class="border-t border-white/10"></div>
</div>