<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');

$db_error_message = null;

try {
    $stmt = $pdo->query("SELECT * FROM website_config WHERE id = 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name_from_db = htmlspecialchars($config['company_name'] ?? 'Nombre de la Empresa');
        $contact_phone_from_db = htmlspecialchars($config['phone_primary'] ?? '');
        $website_url_from_db = htmlspecialchars($config['website_url'] ?? '');
        $value_proposition_from_db = htmlspecialchars($config['value_proposition'] ?? ''); // Leer la propuesta guardada
    } else {
        $company_name_from_db = 'Nombre de la Empresa';
        $contact_phone_from_db = '';
        $website_url_from_db = '';
        $value_proposition_from_db = '';
        $db_error_message = 'No se encontró la configuración. Se usarán valores por defecto.';
    }

} catch (PDOException $e) {
    error_log("Error PDO al cargar configuración web: " . $e->getMessage());
    $company_name_from_db = 'Nombre de la Empresa';
    $contact_phone_from_db = '';
    $website_url_from_db = '';
    $value_proposition_from_db = '';
    $db_error_message = 'Error de Base de Datos al cargar configuración: ' . $e->getMessage();
} catch (Exception $e) {
    error_log("General Error al cargar configuración web: " . $e->getMessage());
    $company_name_from_db = 'Nombre de la Empresa';
    $contact_phone_from_db = '';
    $website_url_from_db = '';
    $value_proposition_from_db = '';
    $db_error_message = 'Error inesperado al cargar configuración: ' . $e->getMessage();
}

ob_end_clean();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Dashboard De Recursos <?php echo htmlspecialchars($branding['iastock_name']); ?> Powered By <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://unpkg.com/imask"></script>

    <link rel="stylesheet" href="style.css">
    <script src="files/header-manager.js"></script>
    
   <style>
    @media (max-width: 768px) {
        .page-header-container { display: none !important; }
    }

    /* =================================================================== */
    /* FICHAS DE CATEGORÍAS (cat-chip) */
    /* =================================================================== */
    .cat-chip {
        display: inline-flex; align-items: center; justify-content: center; gap: .5rem;
        padding: .5rem 1rem; border-radius: 999px; border: 1px solid #e5e7eb;
        background: #f9fafb;
        transition: all .2s ease; text-decoration: none; white-space: nowrap;
    }
    .cat-chip:hover { background: #f3f4f6; border-color: #d1d5db; transform: translateY(-2px); }
    .cat-chip.active { background: var(--color-primary); color: #fff; border-color: var(--color-primary); }
    .cat-chip svg { width: 18px; height: 18px; }

    /* =================================================================== */
    /* TARJETAS DE RECURSOS (asset-card) - VERSIÓN OSCURA/INVERTIDA */
    /* =================================================================== */
    .asset-card {
        background: #0f172a; border: 1px solid #334155; border-radius: 16px;
        padding: 24px; display: flex; flex-direction: column; transition: all .2s ease;
        box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1), 0 2px 4px -2px rgba(0,0,0,0.06);
    }
    .asset-card:hover { transform: translateY(-5px); border-color: #475569; box-shadow: 0 10px 15px -3px rgba(0,0,0,0.2), 0 4px 6px -4px rgba(0,0,0,0.1); }
    .asset-card__top { display: flex; align-items: center; justify-content: space-between; margin-bottom: .75rem; }
    .asset-card__top svg { width: 24px; height: 24px; color: #94a3b8; }
    .asset-card__title { line-height: 1.3; margin: 4px 0 2px; }
    .asset-card__desc { color: #94a3b8; line-height: 1.5; margin-top: 4px; flex: 1 1 auto; }
    .asset-card__meta { display: flex; flex-wrap: wrap; gap: .75rem; align-items: center; margin-top: .75rem; color: #94a3b8; }
    .asset-card__meta .meta { display: inline-flex; gap: .35rem; align-items: center; }
    .asset-card__meta .meta svg { width: 16px; height: 16px; }
    .asset-card__btn {
        justify-content: center; padding: .65rem 1rem; border-radius: 10px;
        background: var(--color-highlight); color: #0f172a;
        transition: all .2s ease; text-decoration: none;
    }
    .asset-card__btn:hover { opacity: .9; transform: scale(1.02); }
    .asset-card__btn svg { width: 18px; height: 18px; }

    /* =================================================================== */
    /* ETIQUETAS (Pills) */
    /* =================================================================== */
    .pill {
        display: inline-flex; gap: .35rem; align-items: center; border-radius: 999px;
        text-transform: uppercase;
        padding: .35rem .6rem; letter-spacing: .4px;
    }
    .pill--new { background: #dcfce7; color: #166534; }
    .pill--hot { background: #fee2e2; color: #991b1b; }
    .pill--updated { background: #dbeafe; color: #1e40af; }
    .pill--premium { background: #fffbeb; color: #b45309; }

    /* =================================================================== */
    /* TARJETAS DE ESTADÍSTICAS (stat-card) */
    /* =================================================================== */
    .stat-card {
        background: #ffffff;
        border-radius: 12px;
        box-shadow: 0 1px 3px 0 rgba(0,0,0,0.1), 0 1px 2px -1px rgba(0,0,0,0.1);
        transition: all 0.2s ease;
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        padding: 18px;
    }

    .stat-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1), 0 2px 4px -2px rgba(0,0,0,0.06);
    }

    .stat-card__icon {
        background-color: var(--color-secondary);
        color: var(--color-text-light);
        border-radius: 10px;
        padding: 8px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    .stat-card__icon svg {
        width: 40px;
        height: 40px;
    }

    .stat-card__value {
        color: var(--color-text-dark);
        line-height: 1;
    }

    .stat-card__label {
        color: var(--color-text-dark);
    }

    .stat-card__action {
        width: 100%;
    }

    .stat-card .asset-card__btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 8px 16px;
        border-radius: 8px;
        background-color: var(--color-highlight);
        color: var(--color-text-dark);
        text-decoration: none;
        transition: background-color 0.2s;
        width: 100%;
    }

    .stat-card .asset-card__btn:hover {
        background-color: #EAB308;
    }

    .stat-card .asset-card__btn svg {
        width: 16px;
        height: 16px;
        margin-right: 4px;
    }

    /* =================================================================== */
    /* TARJETAS DE NICHO (Niche Card - Adaptadas para CATEGORÍAS) */
    /* =================================================================== */
    .niche-card {
        position: relative;
        border-radius: 16px;
        overflow: hidden;
        height: 350px;
        cursor: pointer;
        box-shadow: 0 10px 15px -3px rgba(0,0,0,0.3), 0 4px 6px -4px rgba(0,0,0,0.3);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .niche-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 25px -5px rgba(0,0,0,0.5), 0 8px 10px -6px rgba(0,0,0,0.5);
    }

    .niche-card__bg {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
        filter: brightness(0.4);
        transition: filter 0.3s ease;
    }

    .niche-card:hover .niche-card__bg {
        filter: brightness(0.3);
    }

    .niche-card__content {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        padding: 24px;
        color: white;
    }

    .niche-card__icon {
        position: absolute;
        top: 16px;
        right: 16px;
        background: rgba(0, 0, 0, 0.4);
        border-radius: 50%;
        padding: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
    }

    .niche-card__title {
        line-height: 1.1;
        text-transform: uppercase;
        margin-bottom: 4px;
    }

    .niche-card__subtitle {
        color: var(--color-highlight);
    }

    .niche-card__action {
        display: block;
    }
</style>
</head>

<body data-page-title="Bienvenido Al Panel Crativo IAStock™"
      data-page-subtitle="Tu Centro De Recursos Y Activos Para Promoción"
      data-page-icon="graduation-cap">

   <div id="toast-container" class="toast-container"></div>

    <?php include 'files/gtm-body.php'; ?>

<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="off-canvas-overlay"></div> 
    
    <?php include 'stock-menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
            
            <div class="show-widget-container hidden">
    <button class="show-widget-btn inline-flex items-center gap-3 text-base font-bold text-white bg-[var(--color-primary)] rounded-lg shadow-lg shadow-[var(--color-primary)]/20 py-3 px-6 transform hover:-translate-y-1 hover:shadow-xl transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[var(--color-secondary)]"
        
        data-widget-id="iastock-intro-video">

        <i data-lucide="eye" class="w-5 h-5"></i>
        <span>VER VIDEO PRESENTACIÓN </span>
    </button>
</div>

        </header>

        <div id="content-area" class="p-4 md:p-8 space-y-12">

<section id="iastock-intro-video" class="p-6 md:p-10 video-widget">
    <div class="blob bl1"></div><div class="blob bl2"></div>
    <div class="relative grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
        <div>
            <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-white/10 ring-1 ring-white/15 mb-4">
                <i data-lucide="archive" class="w-4 h-4"></i>
                <span class="text-xs tracking-wide font-semibold">Tu Banco De Contenido Creativo</span>
            </div>
            <h1 class="text-3xl md:text-4xl font-black uppercase leading-tight tracking-tight">
                <span class="text-[var(--color-highlight)]">IAStock™ </span> Para Negocios
                <span class="block text-white/90 text-2xl md:text-4xl mt-1">Imágenes, Videos, Audio, Etc.</span>
            </h1>
            <p class="text-white/80 mt-4 max-w-2xl text-base md:text-lg">
                Encuentra contenido profesional listo para usar en tu promoción pagada u organica, destaque sobre la competencia con contenido profesional hecho con IA.
            </p>
            <div class="mt-6 flex flex-wrap gap-3">
                <a href="#ia-stock-stats" class="inline-flex items-center gap-2 text-sm font-bold px-4 py-2 rounded-lg bg-[var(--color-highlight)] text-slate-900 hover:opacity-90 transition-all transform hover:scale-105">
                    <i data-lucide="compass" class="w-5 h-5"></i> EXPLORAR CONTENIDO
                </a>
            </div>
        </div>

        <div class="w-full">
            <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                <div class="relative w-full" style="padding-bottom: 56.25%;">
                    <video class="absolute top-0 left-0 w-full h-full object-cover" controls controlslist="nodownload nofullscreen" preload="metadata">
                        <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                        TU NAVEGADOR NO SOPORTA LA ETIQUETA DE VIDEO
                    </video>
                    <div id="playOverlay" class="absolute inset-0 flex justify-center items-center cursor-pointer group">
                        <img src="img/VideoLeccion-IAMarketing.jpg" alt="VideoLeccion - IAMarketing" class="absolute inset-0 w-full h-full object-cover">
                        <div class="absolute inset-0 w-full h-full bg-black/40 transition-colors group-hover:bg-black/60"></div>
                        <i data-lucide="play" class="relative w-16 h-16 text-white opacity-80 group-hover:opacity-100 transition-opacity"></i>
                    </div>
                </div>
                <div class="p-4 text-white/90 text-sm flex items-center justify-between">
                        <span class="inline-flex items-center gap-2">
                            <i data-lucide="play-circle" class="w-4 h-4"></i>
                            Video Presentación
                        </span>

                        <button class="hide-widget-btn inline-flex items-center gap-2 text-xs font-black text-[var(--color-highlight)] hover:text-[var(--color-highlight)] transition-colors py-1 px-2 rounded-md"
                                data-widget-id="iastock-intro-video" 
                                title="Ocultar el video de bienvenida">
                            OCULTAR VIDEO
                            <i data-lucide="square-x" class="w-4 h-4"></i>
                        </button>
                    </div>
            </div>
        </div>
    </div>
</section>
            
<section id="ia-stock-stats">
    <h3 class="text-2xl font-black text-gray-800 mb-4">RESUMEN DE ACTIVOS DISPONIBLES</h3>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-5 gap-3"> 
        
        <div class="stat-card min-h-full">
            <div class="stat-card__icon">
                <i data-lucide="image"></i> 
            </div>
            <div class="stat-card__value text-4xl font-black">500+</div>
            <div class="stat-card__label font-black uppercase">Imágenes</div>
            <div class="stat-card__action">
                <a href="stock-images.php" class="asset-card__btn font-black">
                    <i data-lucide="arrow-right-circle"></i> <span> ACCEDER</span> 
                </a>
            </div>
        </div>
        
        <div class="stat-card min-h-full">
            <div class="stat-card__icon">
                <i data-lucide="video"></i>
            </div>
            <div class="stat-card__value text-4xl font-black">100+</div>
            <div class="stat-card__label font-black uppercase">Videos</div>
            <div class="stat-card__action">
                <a href="stock-videos.php" class="asset-card__btn font-black">
                    <i data-lucide="arrow-right-circle"></i> <span> ACCEDER</span>
                </a>
            </div>
        </div>
        
        <div class="stat-card min-h-full">
            <div class="stat-card__icon">
                <i data-lucide="headphones"></i>
            </div>
            <div class="stat-card__value text-4xl font-black">50+</div>
            <div class="stat-card__label font-black uppercase">Audios</div>
            <div class="stat-card__action">
                <a href="stock-audios.php" class="asset-card__btn font-black">
                    <i data-lucide="arrow-right-circle"></i> <span> ACCEDER</span>
                </a>
            </div>
        </div>
        
        <div class="stat-card min-h-full">
            <div class="stat-card__icon">
                <i data-lucide="file-text"></i>
            </div>
            <div class="stat-card__value text-4xl font-black">10+</div>
            <div class="stat-card__label font-black uppercase">Documentos</div>
            <div class="stat-card__action">
                <a href="stock-documents.php" class="asset-card__btn font-black">
                    <i data-lucide="arrow-right-circle"></i> <span> ACCEDER</span>
                </a>
            </div>
        </div>
        
        <div class="stat-card min-h-full">
            <div class="stat-card__icon">
                <i data-lucide="layout-template"></i>
            </div>
            <div class="stat-card__value text-4xl font-black">10+</div>
            <div class="stat-card__label font-black uppercase">Plantillas</div>
            <div class="stat-card__action">
                <a href="stock-templates.php" class="asset-card__btn font-black">
                   <i data-lucide="arrow-right-circle"></i> <span> ACCEDER</span>
                </a>
            </div>
        </div>
        
    </div>
</section>
            
<section id="ia-stock-latest-visual">
    <h3 class="text-5xl font-black text-gray-800 mb-6">NAVEGACIÓN POR LIBRERÍA DE ACTIVO</h3>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-5 gap-6" id="category-cards-visual">

        <a href="stock-images.php" class="niche-card">
            <div class="niche-card__bg" style="background-image: url('img/Manual01.webp');"></div>
            
            <div class="niche-card__icon">
                <i data-lucide="image" class="w-6 h-6"></i>
            </div>

            <div class="niche-card__content">
                <p class="text-sm font-semibold mb-1 opacity-70 text-[var(--color-highlight)]">Activos Visuales</p>
                <h4 class="niche-card__title">IMÁGENES Y FOTOS</h4>
                <p class="asset-card__btn uppercase text-black"><i data-lucide="arrow-right-circle"></i> <span> ACCEDER</span></p>
            </div>
        </a>

        <a href="stock-videos.php" class="niche-card">
            <div class="niche-card__bg" style="background-image: url('img/Manual02.webp');"></div>
            
            <div class="niche-card__icon">
                <i data-lucide="video" class="w-6 h-6"></i>
            </div>

            <div class="niche-card__content">
                <p class="text-sm font-semibold mb-1 opacity-70 text-[var(--color-highlight)]">Contenido Dinámico</p>
                <h4 class="niche-card__title">VIDEOS DE STOCK</h4>
                <p class="asset-card__btn uppercase">Ver Galería Completa</p>
            </div>
        </a>
        
        <a href="stock-audios.php" class="niche-card">
            <div class="niche-card__bg" style="background-image: url('img/Manual03.webp');"></div>
            
            <div class="niche-card__icon">
                <i data-lucide="headphones" class="w-6 h-6"></i>
            </div>

            <div class="niche-card__content">
                <p class="text-sm font-semibold mb-1 opacity-70 text-[var(--color-highlight)]">Pistas y Efectos</p>
                <h4 class="niche-card__title">AUDIOS Y MÚSICA</h4>
                <p class="asset-card__btn uppercase">Ver Galería Completa</p>
            </div>
        </a>

        <a href="stock-documents.php" class="niche-card">
            <div class="niche-card__bg" style="background-image: url('img/Manual04.webp');"></div>
            
            <div class="niche-card__icon">
                <i data-lucide="file-text" class="w-6 h-6"></i>
            </div>

            <div class="niche-card__content">
                <p class="text-sm font-semibold mb-1 opacity-70 text-[var(--color-highlight)]">Guías y Ebooks</p>
                <h4 class="niche-card__title">DOCUMENTOS</h4>
                <p class="asset-card__btn uppercase">Ver Galería Completa</p>
            </div>
        </a>

        <a href="stock-templates.php" class="niche-card">
            <div class="niche-card__bg" style="background-image: url('img/Manual05.webp');"></div>
            
            <div class="niche-card__icon">
                <i data-lucide="layout-template" class="w-6 h-6"></i>
            </div>

            <div class="niche-card__content">
                <p class="text-sm font-semibold mb-1 opacity-70 text-[var(--color-highlight)]">Diseños Listos</p>
                <h4 class="niche-card__title">PLANTILLAS</h4>
                <p class="asset-card__btn uppercase">Ver Galería Completa</p>
            </div>
        </a>
        
    </div>
</section>

            <?php include 'push.php'; ?>
        </div>
    </main>
</div>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        // JS para el menú móvil
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebar-overlay');
        const sidebarCloseBtn = document.getElementById('sidebarCloseBtn');

        function toggleSidebar() {
            if (sidebar) sidebar.classList.toggle('-translate-x-full');
            if (sidebarOverlay) sidebarOverlay.classList.toggle('hidden');
        }

        if (mobileMenuButton) mobileMenuButton.addEventListener('click', toggleSidebar);
        if (sidebarCloseBtn) sidebarCloseBtn.addEventListener('click', toggleSidebar);
        if (sidebarOverlay) sidebarOverlay.addEventListener('click', toggleSidebar);
        
        // Inicializar iconos Lucide
        if (typeof lucide !== 'undefined') {
            lucide.createIcons();
        }
    });
</script>
<script>
document.addEventListener('DOMContentLoaded', () => {

    // Función principal que maneja el ocultamiento, la reaparición y el Local Storage
    const toggleWidgetVisibility = (widgetId, isHidden) => {
        const widget = document.getElementById(widgetId);
        // Encuentra el contenedor del botón de mostrar usando el data-widget-id
        const showContainer = document.querySelector(`.show-widget-container [data-widget-id="${widgetId}"]`)?.closest('.show-widget-container');
        const videoPlayer = widget ? widget.querySelector('video') : null;

        if (!widget || !showContainer) return; // Se detiene si no encuentra los elementos

        if (isHidden) {
            // Acción para OCULTAR
            widget.classList.add('hidden');
            showContainer.classList.remove('hidden');
            // IMPORTANTE: Detiene el video para ahorrar recursos
            if (videoPlayer) videoPlayer.pause(); 
        } else {
            // Acción para MOSTRAR
            widget.classList.remove('hidden');
            showContainer.classList.add('hidden');
        }

        // Guarda la preferencia en Local Storage, individualmente para cada widget
        localStorage.setItem(`hide_${widgetId}`, isHidden ? 'true' : 'false');
    };

    // 1. Configurar los botones de OCULTAR (clase: hide-widget-btn)
    document.querySelectorAll('.hide-widget-btn').forEach(button => {
        button.addEventListener('click', (event) => {
            const widgetId = event.currentTarget.dataset.widgetId; // Obtiene el ID a ocultar
            toggleWidgetVisibility(widgetId, true); 
        });
    });

    // 2. Configurar los botones de MOSTRAR (clase: show-widget-btn)
    document.querySelectorAll('.show-widget-btn').forEach(button => {
        button.addEventListener('click', (event) => {
            const widgetId = event.currentTarget.dataset.widgetId; // Obtiene el ID a mostrar
            toggleWidgetVisibility(widgetId, false); 
        });
    });

    // 3. Comprobar y aplicar el estado guardado al cargar la página para TODOS los widgets
    document.querySelectorAll('.video-widget').forEach(widget => {
        const widgetId = widget.id;
        const isHidden = localStorage.getItem(`hide_${widgetId}`) === 'true';
        if (isHidden) {
            // Si el usuario lo ocultó antes, se aplica el estado de oculto
            toggleWidgetVisibility(widgetId, true);
        }
    });
});
</script>
<script src="files/toast.js"></script>
</body>
</html>