<?php
// definitions.php
return [
    // --- FASE 1: GESTIÓN DE CLIENTES ---
    'dashboard' => [
        'token' => 'menu_dashboard',
        'actions' => ['view' => 'perm_view']
    ],
    'assistant' => [
        'token' => 'menu_assistant',
        'actions' => ['view' => 'perm_view_assistant']
    ],
    'agenda' => [
        'token' => 'menu_agenda',
        'actions' => [
            'view' => 'perm_view',
            'create' => 'perm_create',
            'edit' => 'perm_edit',
            'delete' => 'perm_delete'
        ]
    ],
    'clients' => [
        'token' => 'menu_clients',
        'actions' => [
            'view' => 'perm_view',
            'create' => 'perm_create',
            'edit' => 'perm_edit',
            'delete' => 'perm_delete',
            'access' => 'perm_sensitive_data'
        ]
    ],
    'invoices' => [
        'token' => 'menu_invoices',
        'actions' => [
            'view' => 'perm_view',
            'create' => 'perm_create',
            'edit' => 'perm_edit',
            'delete' => 'perm_delete'
        ]
    ],
    'projects' => [
        'token' => 'menu_projects',
        'actions' => [
            'view' => 'perm_view',
            'manage' => 'perm_manage'
        ]
    ],
    'recurring' => [
        'token' => 'menu_recurring',
        'actions' => [
            'view' => 'perm_view',
            'manage' => 'perm_manage'
        ]
    ],
    'routes' => [
        'token' => 'menu_routes',
        'actions' => [
            'view' => 'perm_view',
            'manage' => 'perm_manage'
        ]
    ],

    // --- FASE 2: OPERACIÓN DEL NEGOCIO ---
    'services' => [
        'token' => 'menu_services',
        'actions' => [
            'view' => 'perm_view',
            'manage' => 'perm_manage_catalog'
        ]
    ],
    'finances' => [ 
        'token' => 'menu_finances',
        'actions' => [
            'view' => 'perm_view_reports',
            'expenses' => 'perm_manage_expenses'
        ]
    ],
    'staff' => [
        'token' => 'menu_staff',
        'actions' => [
            'view' => 'perm_view',
            'create' => 'perm_create',
            'edit' => 'perm_edit',
            'delete' => 'perm_delete',
            'payroll' => 'perm_manage_payroll'
        ]
    ],
    'complaints' => [
        'token' => 'menu_complaints',
        'actions' => [
            'view' => 'perm_view',
            'resolve' => 'perm_resolve'
        ]
    ],
    'performance' => [
        'token' => 'menu_performance',
        'actions' => ['view' => 'perm_view_metrics']
    ],

    // --- FASE 3: PROSPECTOS Y VENTAS ---
    'leads' => [
        'token' => 'menu_leads',
        'actions' => [
            'view' => 'perm_view',
            'create' => 'perm_create',
            'edit' => 'perm_edit',
            'delete' => 'perm_delete'
        ]
    ],
    'lead_funnel' => [
        'token' => 'menu_lead_funnel',
        'actions' => ['view' => 'perm_view_funnel']
    ],
    'quotes' => [
        'token' => 'menu_quotes',
        'actions' => [
            'view' => 'perm_view',
            'create' => 'perm_create',
            'edit' => 'perm_edit',
            'delete' => 'perm_delete'
        ]
    ],
    'quotes_funnel' => [
        'token' => 'menu_quotes_funnel',
        'actions' => ['view' => 'perm_view_funnel']
    ],
    'discarded_leads' => [
        'token' => 'menu_discarded',
        'actions' => [
            'view' => 'perm_view',
            'restore' => 'perm_restore'
        ]
    ],

    // --- HERRAMIENTAS ---
    'business_config' => [
        'token' => 'menu_business_config',
        'actions' => [
            'view' => 'perm_view',
            'edit' => 'perm_edit_config'
        ]
    ],
    'account' => [ 
        'token' => 'menu_account',
        'actions' => [
            'manage' => 'perm_manage_subscription'
        ]
    ],
    'academy' => [
        'token' => 'menu_academy',
        'actions' => ['view' => 'perm_view_tutorials']
    ]
];