<?php
function formatCurrency($amount, $withSymbol = true) {
    if (!is_numeric($amount)) return $amount;
    
    // Usa directamente la configuración cargada
    $formatted = number_format(
        (float)$amount, 
        2, 
        CRM_DEC_POINT, 
        CRM_THOUSANDS_SEP
    );
    
    if ($withSymbol) {
        // Lógica posicional genérica (no basada en país)
        if (CRM_CURRENCY_POS === 'after') {
            return $formatted . ' ' . CRM_CURRENCY_SYMBOL;
        }
        return CRM_CURRENCY_SYMBOL . $formatted;
    }
    
    return $formatted;
}

function formatPhoneNumber($phone) {
    if (empty($phone)) return '';
    
    $cleaned = preg_replace('/[^0-9]/', '', $phone);
    $systemPrefix = str_replace('+', '', CRM_PHONE_PREFIX);
    
    // Si no empieza con el prefijo, se lo ponemos
    if (strpos($cleaned, $systemPrefix) !== 0) {
        return '+' . $systemPrefix . ' ' . $cleaned;
    }
    
    return '+' . $cleaned;
}

function formatDate($dateString, $includeTime = false) {
    if (empty($dateString)) return '';
    
    $timestamp = strtotime($dateString);
    if (!$timestamp) return $dateString;
    
    $format = CRM_DATE_FORMAT; 
    
    if ($includeTime) {
        $format .= ' ' . CRM_TIME_FORMAT;
    }
    
    return date($format, $timestamp);
}

function getWhatsAppLink($phone) {
    $cleaned = preg_replace('/[^0-9]/', '', $phone);
    $systemPrefix = str_replace('+', '', CRM_PHONE_PREFIX);
    
    if (strpos($cleaned, $systemPrefix) !== 0) {
        $cleaned = $systemPrefix . $cleaned;
    }
    
    return "https://wa.me/" . $cleaned;
}
?>